# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListMetricSourceTableItemRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.page_token: Optional[str] = None
        self.page_size: Optional[str] = None
        self.metric_source_id: Optional[str] = None
        self.metric_table_id: Optional[str] = None

    @staticmethod
    def builder() -> "ListMetricSourceTableItemRequestBuilder":
        return ListMetricSourceTableItemRequestBuilder()


class ListMetricSourceTableItemRequestBuilder(object):

    def __init__(self) -> None:
        list_metric_source_table_item_request = ListMetricSourceTableItemRequest()
        list_metric_source_table_item_request.http_method = HttpMethod.GET
        list_metric_source_table_item_request.uri = "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items"
        list_metric_source_table_item_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._list_metric_source_table_item_request: ListMetricSourceTableItemRequest = list_metric_source_table_item_request

    def user_id_type(self, user_id_type: str) -> "ListMetricSourceTableItemRequestBuilder":
        self._list_metric_source_table_item_request.user_id_type = user_id_type
        self._list_metric_source_table_item_request.add_query("user_id_type", user_id_type)
        return self

    def page_token(self, page_token: str) -> "ListMetricSourceTableItemRequestBuilder":
        self._list_metric_source_table_item_request.page_token = page_token
        self._list_metric_source_table_item_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: str) -> "ListMetricSourceTableItemRequestBuilder":
        self._list_metric_source_table_item_request.page_size = page_size
        self._list_metric_source_table_item_request.add_query("page_size", page_size)
        return self

    def metric_source_id(self, metric_source_id: str) -> "ListMetricSourceTableItemRequestBuilder":
        self._list_metric_source_table_item_request.metric_source_id = metric_source_id
        self._list_metric_source_table_item_request.paths["metric_source_id"] = str(metric_source_id)
        return self

    def metric_table_id(self, metric_table_id: str) -> "ListMetricSourceTableItemRequestBuilder":
        self._list_metric_source_table_item_request.metric_table_id = metric_table_id
        self._list_metric_source_table_item_request.paths["metric_table_id"] = str(metric_table_id)
        return self

    def build(self) -> ListMetricSourceTableItemRequest:
        return self._list_metric_source_table_item_request
