# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .metric_item import MetricItem


class ListMetricSourceTableItemResponseBody(object):
    _types = {
        "total": int,
        "has_more": bool,
        "page_token": str,
        "items": List[MetricItem],
    }

    def __init__(self, d=None):
        self.total: Optional[int] = None
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        self.items: Optional[List[MetricItem]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListMetricSourceTableItemResponseBodyBuilder":
        return ListMetricSourceTableItemResponseBodyBuilder()


class ListMetricSourceTableItemResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_metric_source_table_item_response_body = ListMetricSourceTableItemResponseBody()

    def total(self, total: int) -> "ListMetricSourceTableItemResponseBodyBuilder":
        self._list_metric_source_table_item_response_body.total = total
        return self

    def has_more(self, has_more: bool) -> "ListMetricSourceTableItemResponseBodyBuilder":
        self._list_metric_source_table_item_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListMetricSourceTableItemResponseBodyBuilder":
        self._list_metric_source_table_item_response_body.page_token = page_token
        return self

    def items(self, items: List[MetricItem]) -> "ListMetricSourceTableItemResponseBodyBuilder":
        self._list_metric_source_table_item_response_body.items = items
        return self

    def build(self) -> "ListMetricSourceTableItemResponseBody":
        return self._list_metric_source_table_item_response_body
