# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .okr_objective import OkrObjective


class OkrBatch(object):
    _types = {
        "id": int,
        "permission": int,
        "period_id": int,
        "name": str,
        "objective_list": List[OkrObjective],
        "confirm_status": int,
    }

    def __init__(self, d=None):
        self.id: Optional[int] = None
        self.permission: Optional[int] = None
        self.period_id: Optional[int] = None
        self.name: Optional[str] = None
        self.objective_list: Optional[List[OkrObjective]] = None
        self.confirm_status: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OkrBatchBuilder":
        return OkrBatchBuilder()


class OkrBatchBuilder(object):
    def __init__(self) -> None:
        self._okr_batch = OkrBatch()

    def id(self, id: int) -> "OkrBatchBuilder":
        self._okr_batch.id = id
        return self

    def permission(self, permission: int) -> "OkrBatchBuilder":
        self._okr_batch.permission = permission
        return self

    def period_id(self, period_id: int) -> "OkrBatchBuilder":
        self._okr_batch.period_id = period_id
        return self

    def name(self, name: str) -> "OkrBatchBuilder":
        self._okr_batch.name = name
        return self

    def objective_list(self, objective_list: List[OkrObjective]) -> "OkrBatchBuilder":
        self._okr_batch.objective_list = objective_list
        return self

    def confirm_status(self, confirm_status: int) -> "OkrBatchBuilder":
        self._okr_batch.confirm_status = confirm_status
        return self

    def build(self) -> "OkrBatch":
        return self._okr_batch
