# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .okr_detail_objective import OkrDetailObjective
from .okr_name import OkrName


class OkrDetail(object):
    _types = {
        "okr_id": str,
        "period_id": str,
        "period_type": str,
        "name": OkrName,
        "create_time": int,
        "modify_time": int,
        "objective_list": List[OkrDetailObjective],
        "okr_score": int,
    }

    def __init__(self, d=None):
        self.okr_id: Optional[str] = None
        self.period_id: Optional[str] = None
        self.period_type: Optional[str] = None
        self.name: Optional[OkrName] = None
        self.create_time: Optional[int] = None
        self.modify_time: Optional[int] = None
        self.objective_list: Optional[List[OkrDetailObjective]] = None
        self.okr_score: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OkrDetailBuilder":
        return OkrDetailBuilder()


class OkrDetailBuilder(object):
    def __init__(self) -> None:
        self._okr_detail = OkrDetail()

    def okr_id(self, okr_id: str) -> "OkrDetailBuilder":
        self._okr_detail.okr_id = okr_id
        return self

    def period_id(self, period_id: str) -> "OkrDetailBuilder":
        self._okr_detail.period_id = period_id
        return self

    def period_type(self, period_type: str) -> "OkrDetailBuilder":
        self._okr_detail.period_type = period_type
        return self

    def name(self, name: OkrName) -> "OkrDetailBuilder":
        self._okr_detail.name = name
        return self

    def create_time(self, create_time: int) -> "OkrDetailBuilder":
        self._okr_detail.create_time = create_time
        return self

    def modify_time(self, modify_time: int) -> "OkrDetailBuilder":
        self._okr_detail.modify_time = modify_time
        return self

    def objective_list(self, objective_list: List[OkrDetailObjective]) -> "OkrDetailBuilder":
        self._okr_detail.objective_list = objective_list
        return self

    def okr_score(self, okr_score: int) -> "OkrDetailBuilder":
        self._okr_detail.okr_score = okr_score
        return self

    def build(self) -> "OkrDetail":
        return self._okr_detail
