# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .okr_detail_objective_align import OkrDetailObjectiveAlign
from .okr_detail_objective_kr import OkrDetailObjectiveKr
from .okr_name import OkrName


class OkrDetailObjective(object):
    _types = {
        "id": int,
        "okr_id": int,
        "user_id": str,
        "pos": int,
        "score": int,
        "name": OkrName,
        "progress": OkrName,
        "create_time": int,
        "modify_time": int,
        "kr_list": List[OkrDetailObjectiveKr],
        "aligning_objective_list": List[OkrDetailObjectiveAlign],
        "aligned_objective_list": List[OkrDetailObjectiveAlign],
        "weight": float,
    }

    def __init__(self, d=None):
        self.id: Optional[int] = None
        self.okr_id: Optional[int] = None
        self.user_id: Optional[str] = None
        self.pos: Optional[int] = None
        self.score: Optional[int] = None
        self.name: Optional[OkrName] = None
        self.progress: Optional[OkrName] = None
        self.create_time: Optional[int] = None
        self.modify_time: Optional[int] = None
        self.kr_list: Optional[List[OkrDetailObjectiveKr]] = None
        self.aligning_objective_list: Optional[List[OkrDetailObjectiveAlign]] = None
        self.aligned_objective_list: Optional[List[OkrDetailObjectiveAlign]] = None
        self.weight: Optional[float] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OkrDetailObjectiveBuilder":
        return OkrDetailObjectiveBuilder()


class OkrDetailObjectiveBuilder(object):
    def __init__(self) -> None:
        self._okr_detail_objective = OkrDetailObjective()

    def id(self, id: int) -> "OkrDetailObjectiveBuilder":
        self._okr_detail_objective.id = id
        return self

    def okr_id(self, okr_id: int) -> "OkrDetailObjectiveBuilder":
        self._okr_detail_objective.okr_id = okr_id
        return self

    def user_id(self, user_id: str) -> "OkrDetailObjectiveBuilder":
        self._okr_detail_objective.user_id = user_id
        return self

    def pos(self, pos: int) -> "OkrDetailObjectiveBuilder":
        self._okr_detail_objective.pos = pos
        return self

    def score(self, score: int) -> "OkrDetailObjectiveBuilder":
        self._okr_detail_objective.score = score
        return self

    def name(self, name: OkrName) -> "OkrDetailObjectiveBuilder":
        self._okr_detail_objective.name = name
        return self

    def progress(self, progress: OkrName) -> "OkrDetailObjectiveBuilder":
        self._okr_detail_objective.progress = progress
        return self

    def create_time(self, create_time: int) -> "OkrDetailObjectiveBuilder":
        self._okr_detail_objective.create_time = create_time
        return self

    def modify_time(self, modify_time: int) -> "OkrDetailObjectiveBuilder":
        self._okr_detail_objective.modify_time = modify_time
        return self

    def kr_list(self, kr_list: List[OkrDetailObjectiveKr]) -> "OkrDetailObjectiveBuilder":
        self._okr_detail_objective.kr_list = kr_list
        return self

    def aligning_objective_list(self,
                                aligning_objective_list: List[OkrDetailObjectiveAlign]) -> "OkrDetailObjectiveBuilder":
        self._okr_detail_objective.aligning_objective_list = aligning_objective_list
        return self

    def aligned_objective_list(self,
                               aligned_objective_list: List[OkrDetailObjectiveAlign]) -> "OkrDetailObjectiveBuilder":
        self._okr_detail_objective.aligned_objective_list = aligned_objective_list
        return self

    def weight(self, weight: float) -> "OkrDetailObjectiveBuilder":
        self._okr_detail_objective.weight = weight
        return self

    def build(self) -> "OkrDetailObjective":
        return self._okr_detail_objective
