# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .okr_name import OkrName


class OkrDetailObjectiveKr(object):
    _types = {
        "id": int,
        "pos": int,
        "score": int,
        "weight": float,
        "content": OkrName,
        "create_time": int,
        "modify_time": int,
    }

    def __init__(self, d=None):
        self.id: Optional[int] = None
        self.pos: Optional[int] = None
        self.score: Optional[int] = None
        self.weight: Optional[float] = None
        self.content: Optional[OkrName] = None
        self.create_time: Optional[int] = None
        self.modify_time: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OkrDetailObjectiveKrBuilder":
        return OkrDetailObjectiveKrBuilder()


class OkrDetailObjectiveKrBuilder(object):
    def __init__(self) -> None:
        self._okr_detail_objective_kr = OkrDetailObjectiveKr()

    def id(self, id: int) -> "OkrDetailObjectiveKrBuilder":
        self._okr_detail_objective_kr.id = id
        return self

    def pos(self, pos: int) -> "OkrDetailObjectiveKrBuilder":
        self._okr_detail_objective_kr.pos = pos
        return self

    def score(self, score: int) -> "OkrDetailObjectiveKrBuilder":
        self._okr_detail_objective_kr.score = score
        return self

    def weight(self, weight: float) -> "OkrDetailObjectiveKrBuilder":
        self._okr_detail_objective_kr.weight = weight
        return self

    def content(self, content: OkrName) -> "OkrDetailObjectiveKrBuilder":
        self._okr_detail_objective_kr.content = content
        return self

    def create_time(self, create_time: int) -> "OkrDetailObjectiveKrBuilder":
        self._okr_detail_objective_kr.create_time = create_time
        return self

    def modify_time(self, modify_time: int) -> "OkrDetailObjectiveKrBuilder":
        self._okr_detail_objective_kr.modify_time = modify_time
        return self

    def build(self) -> "OkrDetailObjectiveKr":
        return self._okr_detail_objective_kr
