# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .okr_objective_aligned_objective import OkrObjectiveAlignedObjective
from .okr_objective_aligned_objective_owner import OkrObjectiveAlignedObjectiveOwner
from .okr_objective_kr import OkrObjectiveKr
from .okr_objective_progress_rate import OkrObjectiveProgressRate
from .progress_record_simplify import ProgressRecordSimplify


class OkrObjective(object):
    _types = {
        "id": int,
        "permission": int,
        "content": str,
        "progress_report": str,
        "score": int,
        "weight": float,
        "progress_rate": OkrObjectiveProgressRate,
        "kr_list": List[OkrObjectiveKr],
        "aligned_objective_list": List[OkrObjectiveAlignedObjective],
        "aligning_objective_list": List[OkrObjectiveAlignedObjective],
        "progress_record_list": List[ProgressRecordSimplify],
        "progress_rate_percent_last_updated_time": int,
        "progress_rate_status_last_updated_time": int,
        "progress_record_last_updated_time": int,
        "progress_report_last_updated_time": int,
        "score_last_updated_time": int,
        "deadline": int,
        "mentioned_user_list": List[OkrObjectiveAlignedObjectiveOwner],
    }

    def __init__(self, d=None):
        self.id: Optional[int] = None
        self.permission: Optional[int] = None
        self.content: Optional[str] = None
        self.progress_report: Optional[str] = None
        self.score: Optional[int] = None
        self.weight: Optional[float] = None
        self.progress_rate: Optional[OkrObjectiveProgressRate] = None
        self.kr_list: Optional[List[OkrObjectiveKr]] = None
        self.aligned_objective_list: Optional[List[OkrObjectiveAlignedObjective]] = None
        self.aligning_objective_list: Optional[List[OkrObjectiveAlignedObjective]] = None
        self.progress_record_list: Optional[List[ProgressRecordSimplify]] = None
        self.progress_rate_percent_last_updated_time: Optional[int] = None
        self.progress_rate_status_last_updated_time: Optional[int] = None
        self.progress_record_last_updated_time: Optional[int] = None
        self.progress_report_last_updated_time: Optional[int] = None
        self.score_last_updated_time: Optional[int] = None
        self.deadline: Optional[int] = None
        self.mentioned_user_list: Optional[List[OkrObjectiveAlignedObjectiveOwner]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OkrObjectiveBuilder":
        return OkrObjectiveBuilder()


class OkrObjectiveBuilder(object):
    def __init__(self) -> None:
        self._okr_objective = OkrObjective()

    def id(self, id: int) -> "OkrObjectiveBuilder":
        self._okr_objective.id = id
        return self

    def permission(self, permission: int) -> "OkrObjectiveBuilder":
        self._okr_objective.permission = permission
        return self

    def content(self, content: str) -> "OkrObjectiveBuilder":
        self._okr_objective.content = content
        return self

    def progress_report(self, progress_report: str) -> "OkrObjectiveBuilder":
        self._okr_objective.progress_report = progress_report
        return self

    def score(self, score: int) -> "OkrObjectiveBuilder":
        self._okr_objective.score = score
        return self

    def weight(self, weight: float) -> "OkrObjectiveBuilder":
        self._okr_objective.weight = weight
        return self

    def progress_rate(self, progress_rate: OkrObjectiveProgressRate) -> "OkrObjectiveBuilder":
        self._okr_objective.progress_rate = progress_rate
        return self

    def kr_list(self, kr_list: List[OkrObjectiveKr]) -> "OkrObjectiveBuilder":
        self._okr_objective.kr_list = kr_list
        return self

    def aligned_objective_list(self,
                               aligned_objective_list: List[OkrObjectiveAlignedObjective]) -> "OkrObjectiveBuilder":
        self._okr_objective.aligned_objective_list = aligned_objective_list
        return self

    def aligning_objective_list(self,
                                aligning_objective_list: List[OkrObjectiveAlignedObjective]) -> "OkrObjectiveBuilder":
        self._okr_objective.aligning_objective_list = aligning_objective_list
        return self

    def progress_record_list(self, progress_record_list: List[ProgressRecordSimplify]) -> "OkrObjectiveBuilder":
        self._okr_objective.progress_record_list = progress_record_list
        return self

    def progress_rate_percent_last_updated_time(self,
                                                progress_rate_percent_last_updated_time: int) -> "OkrObjectiveBuilder":
        self._okr_objective.progress_rate_percent_last_updated_time = progress_rate_percent_last_updated_time
        return self

    def progress_rate_status_last_updated_time(self,
                                               progress_rate_status_last_updated_time: int) -> "OkrObjectiveBuilder":
        self._okr_objective.progress_rate_status_last_updated_time = progress_rate_status_last_updated_time
        return self

    def progress_record_last_updated_time(self, progress_record_last_updated_time: int) -> "OkrObjectiveBuilder":
        self._okr_objective.progress_record_last_updated_time = progress_record_last_updated_time
        return self

    def progress_report_last_updated_time(self, progress_report_last_updated_time: int) -> "OkrObjectiveBuilder":
        self._okr_objective.progress_report_last_updated_time = progress_report_last_updated_time
        return self

    def score_last_updated_time(self, score_last_updated_time: int) -> "OkrObjectiveBuilder":
        self._okr_objective.score_last_updated_time = score_last_updated_time
        return self

    def deadline(self, deadline: int) -> "OkrObjectiveBuilder":
        self._okr_objective.deadline = deadline
        return self

    def mentioned_user_list(self,
                            mentioned_user_list: List[OkrObjectiveAlignedObjectiveOwner]) -> "OkrObjectiveBuilder":
        self._okr_objective.mentioned_user_list = mentioned_user_list
        return self

    def build(self) -> "OkrObjective":
        return self._okr_objective
