# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .okr_objective_aligned_objective_owner import OkrObjectiveAlignedObjectiveOwner
from .okr_objective_progress_rate import OkrObjectiveProgressRate
from .progress_record_simplify import ProgressRecordSimplify


class OkrObjectiveKr(object):
    _types = {
        "id": int,
        "content": str,
        "score": int,
        "weight": int,
        "kr_weight": float,
        "progress_rate": OkrObjectiveProgressRate,
        "progress_record_list": List[ProgressRecordSimplify],
        "progress_rate_percent_last_updated_time": int,
        "progress_rate_status_last_updated_time": int,
        "progress_record_last_updated_time": int,
        "progress_report_last_updated_time": int,
        "score_last_updated_time": int,
        "deadline": int,
        "mentioned_user_list": List[OkrObjectiveAlignedObjectiveOwner],
    }

    def __init__(self, d=None):
        self.id: Optional[int] = None
        self.content: Optional[str] = None
        self.score: Optional[int] = None
        self.weight: Optional[int] = None
        self.kr_weight: Optional[float] = None
        self.progress_rate: Optional[OkrObjectiveProgressRate] = None
        self.progress_record_list: Optional[List[ProgressRecordSimplify]] = None
        self.progress_rate_percent_last_updated_time: Optional[int] = None
        self.progress_rate_status_last_updated_time: Optional[int] = None
        self.progress_record_last_updated_time: Optional[int] = None
        self.progress_report_last_updated_time: Optional[int] = None
        self.score_last_updated_time: Optional[int] = None
        self.deadline: Optional[int] = None
        self.mentioned_user_list: Optional[List[OkrObjectiveAlignedObjectiveOwner]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OkrObjectiveKrBuilder":
        return OkrObjectiveKrBuilder()


class OkrObjectiveKrBuilder(object):
    def __init__(self) -> None:
        self._okr_objective_kr = OkrObjectiveKr()

    def id(self, id: int) -> "OkrObjectiveKrBuilder":
        self._okr_objective_kr.id = id
        return self

    def content(self, content: str) -> "OkrObjectiveKrBuilder":
        self._okr_objective_kr.content = content
        return self

    def score(self, score: int) -> "OkrObjectiveKrBuilder":
        self._okr_objective_kr.score = score
        return self

    def weight(self, weight: int) -> "OkrObjectiveKrBuilder":
        self._okr_objective_kr.weight = weight
        return self

    def kr_weight(self, kr_weight: float) -> "OkrObjectiveKrBuilder":
        self._okr_objective_kr.kr_weight = kr_weight
        return self

    def progress_rate(self, progress_rate: OkrObjectiveProgressRate) -> "OkrObjectiveKrBuilder":
        self._okr_objective_kr.progress_rate = progress_rate
        return self

    def progress_record_list(self, progress_record_list: List[ProgressRecordSimplify]) -> "OkrObjectiveKrBuilder":
        self._okr_objective_kr.progress_record_list = progress_record_list
        return self

    def progress_rate_percent_last_updated_time(self,
                                                progress_rate_percent_last_updated_time: int) -> "OkrObjectiveKrBuilder":
        self._okr_objective_kr.progress_rate_percent_last_updated_time = progress_rate_percent_last_updated_time
        return self

    def progress_rate_status_last_updated_time(self,
                                               progress_rate_status_last_updated_time: int) -> "OkrObjectiveKrBuilder":
        self._okr_objective_kr.progress_rate_status_last_updated_time = progress_rate_status_last_updated_time
        return self

    def progress_record_last_updated_time(self, progress_record_last_updated_time: int) -> "OkrObjectiveKrBuilder":
        self._okr_objective_kr.progress_record_last_updated_time = progress_record_last_updated_time
        return self

    def progress_report_last_updated_time(self, progress_report_last_updated_time: int) -> "OkrObjectiveKrBuilder":
        self._okr_objective_kr.progress_report_last_updated_time = progress_report_last_updated_time
        return self

    def score_last_updated_time(self, score_last_updated_time: int) -> "OkrObjectiveKrBuilder":
        self._okr_objective_kr.score_last_updated_time = score_last_updated_time
        return self

    def deadline(self, deadline: int) -> "OkrObjectiveKrBuilder":
        self._okr_objective_kr.deadline = deadline
        return self

    def mentioned_user_list(self,
                            mentioned_user_list: List[OkrObjectiveAlignedObjectiveOwner]) -> "OkrObjectiveKrBuilder":
        self._okr_objective_kr.mentioned_user_list = mentioned_user_list
        return self

    def build(self) -> "OkrObjectiveKr":
        return self._okr_objective_kr
