# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class PatchMetricSourceTableItemRequestBody(object):
    _types = {
        "metric_initial_value": float,
        "metric_target_value": float,
        "metric_current_value": float,
        "supported_user_id": str,
    }

    def __init__(self, d=None):
        self.metric_initial_value: Optional[float] = None
        self.metric_target_value: Optional[float] = None
        self.metric_current_value: Optional[float] = None
        self.supported_user_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PatchMetricSourceTableItemRequestBodyBuilder":
        return PatchMetricSourceTableItemRequestBodyBuilder()


class PatchMetricSourceTableItemRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._patch_metric_source_table_item_request_body = PatchMetricSourceTableItemRequestBody()

    def metric_initial_value(self, metric_initial_value: float) -> "PatchMetricSourceTableItemRequestBodyBuilder":
        self._patch_metric_source_table_item_request_body.metric_initial_value = metric_initial_value
        return self

    def metric_target_value(self, metric_target_value: float) -> "PatchMetricSourceTableItemRequestBodyBuilder":
        self._patch_metric_source_table_item_request_body.metric_target_value = metric_target_value
        return self

    def metric_current_value(self, metric_current_value: float) -> "PatchMetricSourceTableItemRequestBodyBuilder":
        self._patch_metric_source_table_item_request_body.metric_current_value = metric_current_value
        return self

    def supported_user_id(self, supported_user_id: str) -> "PatchMetricSourceTableItemRequestBodyBuilder":
        self._patch_metric_source_table_item_request_body.supported_user_id = supported_user_id
        return self

    def build(self) -> "PatchMetricSourceTableItemRequestBody":
        return self._patch_metric_source_table_item_request_body
