# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .metric_unit import MetricUnit


class PatchMetricSourceTableItemResponseBody(object):
    _types = {
        "metric_item_id": str,
        "user_id": str,
        "period_id": str,
        "metric_unit": MetricUnit,
        "metric_initial_value": float,
        "metric_target_value": float,
        "metric_current_value": float,
        "supported_user_id": str,
        "kr_id": str,
        "updated_at": int,
        "updated_by": str,
    }

    def __init__(self, d=None):
        self.metric_item_id: Optional[str] = None
        self.user_id: Optional[str] = None
        self.period_id: Optional[str] = None
        self.metric_unit: Optional[MetricUnit] = None
        self.metric_initial_value: Optional[float] = None
        self.metric_target_value: Optional[float] = None
        self.metric_current_value: Optional[float] = None
        self.supported_user_id: Optional[str] = None
        self.kr_id: Optional[str] = None
        self.updated_at: Optional[int] = None
        self.updated_by: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PatchMetricSourceTableItemResponseBodyBuilder":
        return PatchMetricSourceTableItemResponseBodyBuilder()


class PatchMetricSourceTableItemResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._patch_metric_source_table_item_response_body = PatchMetricSourceTableItemResponseBody()

    def metric_item_id(self, metric_item_id: str) -> "PatchMetricSourceTableItemResponseBodyBuilder":
        self._patch_metric_source_table_item_response_body.metric_item_id = metric_item_id
        return self

    def user_id(self, user_id: str) -> "PatchMetricSourceTableItemResponseBodyBuilder":
        self._patch_metric_source_table_item_response_body.user_id = user_id
        return self

    def period_id(self, period_id: str) -> "PatchMetricSourceTableItemResponseBodyBuilder":
        self._patch_metric_source_table_item_response_body.period_id = period_id
        return self

    def metric_unit(self, metric_unit: MetricUnit) -> "PatchMetricSourceTableItemResponseBodyBuilder":
        self._patch_metric_source_table_item_response_body.metric_unit = metric_unit
        return self

    def metric_initial_value(self, metric_initial_value: float) -> "PatchMetricSourceTableItemResponseBodyBuilder":
        self._patch_metric_source_table_item_response_body.metric_initial_value = metric_initial_value
        return self

    def metric_target_value(self, metric_target_value: float) -> "PatchMetricSourceTableItemResponseBodyBuilder":
        self._patch_metric_source_table_item_response_body.metric_target_value = metric_target_value
        return self

    def metric_current_value(self, metric_current_value: float) -> "PatchMetricSourceTableItemResponseBodyBuilder":
        self._patch_metric_source_table_item_response_body.metric_current_value = metric_current_value
        return self

    def supported_user_id(self, supported_user_id: str) -> "PatchMetricSourceTableItemResponseBodyBuilder":
        self._patch_metric_source_table_item_response_body.supported_user_id = supported_user_id
        return self

    def kr_id(self, kr_id: str) -> "PatchMetricSourceTableItemResponseBodyBuilder":
        self._patch_metric_source_table_item_response_body.kr_id = kr_id
        return self

    def updated_at(self, updated_at: int) -> "PatchMetricSourceTableItemResponseBodyBuilder":
        self._patch_metric_source_table_item_response_body.updated_at = updated_at
        return self

    def updated_by(self, updated_by: str) -> "PatchMetricSourceTableItemResponseBodyBuilder":
        self._patch_metric_source_table_item_response_body.updated_by = updated_by
        return self

    def build(self) -> "PatchMetricSourceTableItemResponseBody":
        return self._patch_metric_source_table_item_response_body
