# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .patch_period_request_body import PatchPeriodRequestBody


class PatchPeriodRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.period_id: Optional[str] = None
        self.request_body: Optional[PatchPeriodRequestBody] = None

    @staticmethod
    def builder() -> "PatchPeriodRequestBuilder":
        return PatchPeriodRequestBuilder()


class PatchPeriodRequestBuilder(object):

    def __init__(self) -> None:
        patch_period_request = PatchPeriodRequest()
        patch_period_request.http_method = HttpMethod.PATCH
        patch_period_request.uri = "/open-apis/okr/v1/periods/:period_id"
        patch_period_request.token_types = {AccessTokenType.TENANT}
        self._patch_period_request: PatchPeriodRequest = patch_period_request

    def period_id(self, period_id: str) -> "PatchPeriodRequestBuilder":
        self._patch_period_request.period_id = period_id
        self._patch_period_request.paths["period_id"] = str(period_id)
        return self

    def request_body(self, request_body: PatchPeriodRequestBody) -> "PatchPeriodRequestBuilder":
        self._patch_period_request.request_body = request_body
        self._patch_period_request.body = request_body
        return self

    def build(self) -> PatchPeriodRequest:
        return self._patch_period_request
