# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class ProgressItem(object):
    _types = {
        "content": str,
        "timestamp": int,
        "mention_list": List[str],
    }

    def __init__(self, d=None):
        self.content: Optional[str] = None
        self.timestamp: Optional[int] = None
        self.mention_list: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ProgressItemBuilder":
        return ProgressItemBuilder()


class ProgressItemBuilder(object):
    def __init__(self) -> None:
        self._progress_item = ProgressItem()

    def content(self, content: str) -> "ProgressItemBuilder":
        self._progress_item.content = content
        return self

    def timestamp(self, timestamp: int) -> "ProgressItemBuilder":
        self._progress_item.timestamp = timestamp
        return self

    def mention_list(self, mention_list: List[str]) -> "ProgressItemBuilder":
        self._progress_item.mention_list = mention_list
        return self

    def build(self) -> "ProgressItem":
        return self._progress_item
