# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .content_block import ContentBlock


class ProgressRecord(object):
    _types = {
        "progress_id": int,
        "modify_time": int,
        "content": ContentBlock,
    }

    def __init__(self, d=None):
        self.progress_id: Optional[int] = None
        self.modify_time: Optional[int] = None
        self.content: Optional[ContentBlock] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ProgressRecordBuilder":
        return ProgressRecordBuilder()


class ProgressRecordBuilder(object):
    def __init__(self) -> None:
        self._progress_record = ProgressRecord()

    def progress_id(self, progress_id: int) -> "ProgressRecordBuilder":
        self._progress_record.progress_id = progress_id
        return self

    def modify_time(self, modify_time: int) -> "ProgressRecordBuilder":
        self._progress_record.modify_time = modify_time
        return self

    def content(self, content: ContentBlock) -> "ProgressRecordBuilder":
        self._progress_record.content = content
        return self

    def build(self) -> "ProgressRecord":
        return self._progress_record
