# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class TaskInfo(object):
    _types = {
        "task_id": str,
        "app_token": str,
        "user_id": str,
        "okr_id": str,
        "period_id": str,
    }

    def __init__(self, d=None):
        self.task_id: Optional[str] = None
        self.app_token: Optional[str] = None
        self.user_id: Optional[str] = None
        self.okr_id: Optional[str] = None
        self.period_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TaskInfoBuilder":
        return TaskInfoBuilder()


class TaskInfoBuilder(object):
    def __init__(self) -> None:
        self._task_info = TaskInfo()

    def task_id(self, task_id: str) -> "TaskInfoBuilder":
        self._task_info.task_id = task_id
        return self

    def app_token(self, app_token: str) -> "TaskInfoBuilder":
        self._task_info.app_token = app_token
        return self

    def user_id(self, user_id: str) -> "TaskInfoBuilder":
        self._task_info.user_id = user_id
        return self

    def okr_id(self, okr_id: str) -> "TaskInfoBuilder":
        self._task_info.okr_id = okr_id
        return self

    def period_id(self, period_id: str) -> "TaskInfoBuilder":
        self._task_info.period_id = period_id
        return self

    def build(self) -> "TaskInfo":
        return self._task_info
