# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .upload_image_request_body import UploadImageRequestBody


class UploadImageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[UploadImageRequestBody] = None

    @staticmethod
    def builder() -> "UploadImageRequestBuilder":
        return UploadImageRequestBuilder()


class UploadImageRequestBuilder(object):

    def __init__(self) -> None:
        upload_image_request = UploadImageRequest()
        upload_image_request.http_method = HttpMethod.POST
        upload_image_request.uri = "/open-apis/okr/v1/images/upload"
        upload_image_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._upload_image_request: UploadImageRequest = upload_image_request

    def request_body(self, request_body: UploadImageRequestBody) -> "UploadImageRequestBuilder":
        self._upload_image_request.request_body = request_body
        self._upload_image_request.body = request_body
        return self

    def build(self) -> UploadImageRequest:
        return self._upload_image_request
