# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .progress_item import ProgressItem
from .progress_rate import ProgressRate


class UpsertObjectiveKr(object):
    _types = {
        "content": str,
        "mention_list": List[str],
        "score": int,
        "progress_rate": ProgressRate,
        "progress_list": List[ProgressItem],
        "weight": float,
    }

    def __init__(self, d=None):
        self.content: Optional[str] = None
        self.mention_list: Optional[List[str]] = None
        self.score: Optional[int] = None
        self.progress_rate: Optional[ProgressRate] = None
        self.progress_list: Optional[List[ProgressItem]] = None
        self.weight: Optional[float] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UpsertObjectiveKrBuilder":
        return UpsertObjectiveKrBuilder()


class UpsertObjectiveKrBuilder(object):
    def __init__(self) -> None:
        self._upsert_objective_kr = UpsertObjectiveKr()

    def content(self, content: str) -> "UpsertObjectiveKrBuilder":
        self._upsert_objective_kr.content = content
        return self

    def mention_list(self, mention_list: List[str]) -> "UpsertObjectiveKrBuilder":
        self._upsert_objective_kr.mention_list = mention_list
        return self

    def score(self, score: int) -> "UpsertObjectiveKrBuilder":
        self._upsert_objective_kr.score = score
        return self

    def progress_rate(self, progress_rate: ProgressRate) -> "UpsertObjectiveKrBuilder":
        self._upsert_objective_kr.progress_rate = progress_rate
        return self

    def progress_list(self, progress_list: List[ProgressItem]) -> "UpsertObjectiveKrBuilder":
        self._upsert_objective_kr.progress_list = progress_list
        return self

    def weight(self, weight: float) -> "UpsertObjectiveKrBuilder":
        self._upsert_objective_kr.weight = weight
        return self

    def build(self) -> "UpsertObjectiveKr":
        return self._upsert_objective_kr
