# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .user_okr_objective_aligned_objective import UserOkrObjectiveAlignedObjective
from .user_okr_objective_kr import UserOkrObjectiveKr
from .user_okr_objective_progress_rate import UserOkrObjectiveProgressRate


class UserOkrObjective(object):
    _types = {
        "id": str,
        "permission": int,
        "content": str,
        "progress_report": str,
        "score": str,
        "progress_rate": UserOkrObjectiveProgressRate,
        "kr_list": List[UserOkrObjectiveKr],
        "aligned_objective_list": List[UserOkrObjectiveAlignedObjective],
        "aligning_objective_list": List[UserOkrObjectiveAlignedObjective],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.permission: Optional[int] = None
        self.content: Optional[str] = None
        self.progress_report: Optional[str] = None
        self.score: Optional[str] = None
        self.progress_rate: Optional[UserOkrObjectiveProgressRate] = None
        self.kr_list: Optional[List[UserOkrObjectiveKr]] = None
        self.aligned_objective_list: Optional[List[UserOkrObjectiveAlignedObjective]] = None
        self.aligning_objective_list: Optional[List[UserOkrObjectiveAlignedObjective]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UserOkrObjectiveBuilder":
        return UserOkrObjectiveBuilder()


class UserOkrObjectiveBuilder(object):
    def __init__(self) -> None:
        self._user_okr_objective = UserOkrObjective()

    def id(self, id: str) -> "UserOkrObjectiveBuilder":
        self._user_okr_objective.id = id
        return self

    def permission(self, permission: int) -> "UserOkrObjectiveBuilder":
        self._user_okr_objective.permission = permission
        return self

    def content(self, content: str) -> "UserOkrObjectiveBuilder":
        self._user_okr_objective.content = content
        return self

    def progress_report(self, progress_report: str) -> "UserOkrObjectiveBuilder":
        self._user_okr_objective.progress_report = progress_report
        return self

    def score(self, score: str) -> "UserOkrObjectiveBuilder":
        self._user_okr_objective.score = score
        return self

    def progress_rate(self, progress_rate: UserOkrObjectiveProgressRate) -> "UserOkrObjectiveBuilder":
        self._user_okr_objective.progress_rate = progress_rate
        return self

    def kr_list(self, kr_list: List[UserOkrObjectiveKr]) -> "UserOkrObjectiveBuilder":
        self._user_okr_objective.kr_list = kr_list
        return self

    def aligned_objective_list(self, aligned_objective_list: List[
        UserOkrObjectiveAlignedObjective]) -> "UserOkrObjectiveBuilder":
        self._user_okr_objective.aligned_objective_list = aligned_objective_list
        return self

    def aligning_objective_list(self, aligning_objective_list: List[
        UserOkrObjectiveAlignedObjective]) -> "UserOkrObjectiveBuilder":
        self._user_okr_objective.aligning_objective_list = aligning_objective_list
        return self

    def build(self) -> "UserOkrObjective":
        return self._user_okr_objective
