# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .user_okr_objective_progress_rate import UserOkrObjectiveProgressRate


class UserOkrObjectiveKr(object):
    _types = {
        "id": str,
        "content": str,
        "score": int,
        "weight": int,
        "progress_rate": UserOkrObjectiveProgressRate,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.content: Optional[str] = None
        self.score: Optional[int] = None
        self.weight: Optional[int] = None
        self.progress_rate: Optional[UserOkrObjectiveProgressRate] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UserOkrObjectiveKrBuilder":
        return UserOkrObjectiveKrBuilder()


class UserOkrObjectiveKrBuilder(object):
    def __init__(self) -> None:
        self._user_okr_objective_kr = UserOkrObjectiveKr()

    def id(self, id: str) -> "UserOkrObjectiveKrBuilder":
        self._user_okr_objective_kr.id = id
        return self

    def content(self, content: str) -> "UserOkrObjectiveKrBuilder":
        self._user_okr_objective_kr.content = content
        return self

    def score(self, score: int) -> "UserOkrObjectiveKrBuilder":
        self._user_okr_objective_kr.score = score
        return self

    def weight(self, weight: int) -> "UserOkrObjectiveKrBuilder":
        self._user_okr_objective_kr.weight = weight
        return self

    def progress_rate(self, progress_rate: UserOkrObjectiveProgressRate) -> "UserOkrObjectiveKrBuilder":
        self._user_okr_objective_kr.progress_rate = progress_rate
        return self

    def build(self) -> "UserOkrObjectiveKr":
        return self._user_okr_objective_kr
