# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .basic_recognize_image_request_body import BasicRecognizeImageRequestBody


class BasicRecognizeImageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[BasicRecognizeImageRequestBody] = None

    @staticmethod
    def builder() -> "BasicRecognizeImageRequestBuilder":
        return BasicRecognizeImageRequestBuilder()


class BasicRecognizeImageRequestBuilder(object):

    def __init__(self) -> None:
        basic_recognize_image_request = BasicRecognizeImageRequest()
        basic_recognize_image_request.http_method = HttpMethod.POST
        basic_recognize_image_request.uri = "/open-apis/optical_char_recognition/v1/image/basic_recognize"
        basic_recognize_image_request.token_types = {AccessTokenType.TENANT}
        self._basic_recognize_image_request: BasicRecognizeImageRequest = basic_recognize_image_request

    def request_body(self, request_body: BasicRecognizeImageRequestBody) -> "BasicRecognizeImageRequestBuilder":
        self._basic_recognize_image_request.request_body = request_body
        self._basic_recognize_image_request.body = request_body
        return self

    def build(self) -> BasicRecognizeImageRequest:
        return self._basic_recognize_image_request
