# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Credentials(object):
    _types = {
        "email": str,
        "mobile": str,
        "user_id": str,
    }

    def __init__(self, d=None):
        self.email: Optional[str] = None
        self.mobile: Optional[str] = None
        self.user_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CredentialsBuilder":
        return CredentialsBuilder()


class CredentialsBuilder(object):
    def __init__(self) -> None:
        self._credentials = Credentials()

    def email(self, email: str) -> "CredentialsBuilder":
        self._credentials.email = email
        return self

    def mobile(self, mobile: str) -> "CredentialsBuilder":
        self._credentials.mobile = mobile
        return self

    def user_id(self, user_id: str) -> "CredentialsBuilder":
        self._credentials.user_id = user_id
        return self

    def build(self) -> "Credentials":
        return self._credentials
