# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .system_status import SystemStatus


class CreateSystemStatusRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[SystemStatus] = None

    @staticmethod
    def builder() -> "CreateSystemStatusRequestBuilder":
        return CreateSystemStatusRequestBuilder()


class CreateSystemStatusRequestBuilder(object):

    def __init__(self) -> None:
        create_system_status_request = CreateSystemStatusRequest()
        create_system_status_request.http_method = HttpMethod.POST
        create_system_status_request.uri = "/open-apis/personal_settings/v1/system_statuses"
        create_system_status_request.token_types = {AccessTokenType.TENANT}
        self._create_system_status_request: CreateSystemStatusRequest = create_system_status_request

    def request_body(self, request_body: SystemStatus) -> "CreateSystemStatusRequestBuilder":
        self._create_system_status_request.request_body = request_body
        self._create_system_status_request.body = request_body
        return self

    def build(self) -> CreateSystemStatusRequest:
        return self._create_system_status_request
