# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .system_status import SystemStatus


class ListSystemStatusResponseBody(object):
    _types = {
        "items": List[SystemStatus],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[SystemStatus]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListSystemStatusResponseBodyBuilder":
        return ListSystemStatusResponseBodyBuilder()


class ListSystemStatusResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_system_status_response_body = ListSystemStatusResponseBody()

    def items(self, items: List[SystemStatus]) -> "ListSystemStatusResponseBodyBuilder":
        self._list_system_status_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "ListSystemStatusResponseBodyBuilder":
        self._list_system_status_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListSystemStatusResponseBodyBuilder":
        self._list_system_status_response_body.has_more = has_more
        return self

    def build(self) -> "ListSystemStatusResponseBody":
        return self._list_system_status_response_body
