# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .system_status import SystemStatus


class PatchSystemStatusRequestBody(object):
    _types = {
        "system_status": SystemStatus,
        "update_fields": List[str],
    }

    def __init__(self, d=None):
        self.system_status: Optional[SystemStatus] = None
        self.update_fields: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PatchSystemStatusRequestBodyBuilder":
        return PatchSystemStatusRequestBodyBuilder()


class PatchSystemStatusRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._patch_system_status_request_body = PatchSystemStatusRequestBody()

    def system_status(self, system_status: SystemStatus) -> "PatchSystemStatusRequestBodyBuilder":
        self._patch_system_status_request_body.system_status = system_status
        return self

    def update_fields(self, update_fields: List[str]) -> "PatchSystemStatusRequestBodyBuilder":
        self._patch_system_status_request_body.update_fields = update_fields
        return self

    def build(self) -> "PatchSystemStatusRequestBody":
        return self._patch_system_status_request_body
