# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .system_status_i18n_name import SystemStatusI18nName
from .system_status_sync_setting import SystemStatusSyncSetting


class SystemStatus(object):
    _types = {
        "system_status_id": int,
        "title": str,
        "i18n_title": SystemStatusI18nName,
        "icon_key": str,
        "color": str,
        "priority": int,
        "sync_setting": SystemStatusSyncSetting,
    }

    def __init__(self, d=None):
        self.system_status_id: Optional[int] = None
        self.title: Optional[str] = None
        self.i18n_title: Optional[SystemStatusI18nName] = None
        self.icon_key: Optional[str] = None
        self.color: Optional[str] = None
        self.priority: Optional[int] = None
        self.sync_setting: Optional[SystemStatusSyncSetting] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SystemStatusBuilder":
        return SystemStatusBuilder()


class SystemStatusBuilder(object):
    def __init__(self) -> None:
        self._system_status = SystemStatus()

    def system_status_id(self, system_status_id: int) -> "SystemStatusBuilder":
        self._system_status.system_status_id = system_status_id
        return self

    def title(self, title: str) -> "SystemStatusBuilder":
        self._system_status.title = title
        return self

    def i18n_title(self, i18n_title: SystemStatusI18nName) -> "SystemStatusBuilder":
        self._system_status.i18n_title = i18n_title
        return self

    def icon_key(self, icon_key: str) -> "SystemStatusBuilder":
        self._system_status.icon_key = icon_key
        return self

    def color(self, color: str) -> "SystemStatusBuilder":
        self._system_status.color = color
        return self

    def priority(self, priority: int) -> "SystemStatusBuilder":
        self._system_status.priority = priority
        return self

    def sync_setting(self, sync_setting: SystemStatusSyncSetting) -> "SystemStatusBuilder":
        self._system_status.sync_setting = sync_setting
        return self

    def build(self) -> "SystemStatus":
        return self._system_status
