# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.batch_close_system_status_request import BatchCloseSystemStatusRequest
from ..model.batch_close_system_status_response import BatchCloseSystemStatusResponse
from ..model.batch_open_system_status_request import BatchOpenSystemStatusRequest
from ..model.batch_open_system_status_response import BatchOpenSystemStatusResponse
from ..model.create_system_status_request import CreateSystemStatusRequest
from ..model.create_system_status_response import CreateSystemStatusResponse
from ..model.delete_system_status_request import DeleteSystemStatusRequest
from ..model.delete_system_status_response import DeleteSystemStatusResponse
from ..model.list_system_status_request import ListSystemStatusRequest
from ..model.list_system_status_response import ListSystemStatusResponse
from ..model.patch_system_status_request import PatchSystemStatusRequest
from ..model.patch_system_status_response import PatchSystemStatusResponse


class SystemStatus(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def batch_close(self, request: BatchCloseSystemStatusRequest,
                    option: Optional[RequestOption] = None) -> BatchCloseSystemStatusResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchCloseSystemStatusResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  BatchCloseSystemStatusResponse)
        response.raw = resp

        return response

    async def abatch_close(self, request: BatchCloseSystemStatusRequest,
                           option: Optional[RequestOption] = None) -> BatchCloseSystemStatusResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchCloseSystemStatusResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  BatchCloseSystemStatusResponse)
        response.raw = resp

        return response

    def batch_open(self, request: BatchOpenSystemStatusRequest,
                   option: Optional[RequestOption] = None) -> BatchOpenSystemStatusResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchOpenSystemStatusResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                 BatchOpenSystemStatusResponse)
        response.raw = resp

        return response

    async def abatch_open(self, request: BatchOpenSystemStatusRequest,
                          option: Optional[RequestOption] = None) -> BatchOpenSystemStatusResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchOpenSystemStatusResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                 BatchOpenSystemStatusResponse)
        response.raw = resp

        return response

    def create(self, request: CreateSystemStatusRequest,
               option: Optional[RequestOption] = None) -> CreateSystemStatusResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateSystemStatusResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateSystemStatusResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateSystemStatusRequest,
                      option: Optional[RequestOption] = None) -> CreateSystemStatusResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateSystemStatusResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateSystemStatusResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteSystemStatusRequest,
               option: Optional[RequestOption] = None) -> DeleteSystemStatusResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteSystemStatusResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteSystemStatusResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteSystemStatusRequest,
                      option: Optional[RequestOption] = None) -> DeleteSystemStatusResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteSystemStatusResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteSystemStatusResponse)
        response.raw = resp

        return response

    def list(self, request: ListSystemStatusRequest,
             option: Optional[RequestOption] = None) -> ListSystemStatusResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListSystemStatusResponse = JSON.unmarshal(str(resp.content, UTF_8), ListSystemStatusResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListSystemStatusRequest,
                    option: Optional[RequestOption] = None) -> ListSystemStatusResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListSystemStatusResponse = JSON.unmarshal(str(resp.content, UTF_8), ListSystemStatusResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchSystemStatusRequest,
              option: Optional[RequestOption] = None) -> PatchSystemStatusResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchSystemStatusResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchSystemStatusResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchSystemStatusRequest,
                     option: Optional[RequestOption] = None) -> PatchSystemStatusResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchSystemStatusResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchSystemStatusResponse)
        response.raw = resp

        return response
