# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class FormContent(object):
    _types = {
        "field_id": str,
        "field_name": str,
        "field_value": str,
    }

    def __init__(self, d=None):
        self.field_id: Optional[str] = None
        self.field_name: Optional[str] = None
        self.field_value: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FormContentBuilder":
        return FormContentBuilder()


class FormContentBuilder(object):
    def __init__(self) -> None:
        self._form_content = FormContent()

    def field_id(self, field_id: str) -> "FormContentBuilder":
        self._form_content.field_id = field_id
        return self

    def field_name(self, field_name: str) -> "FormContentBuilder":
        self._form_content.field_name = field_name
        return self

    def field_value(self, field_value: str) -> "FormContentBuilder":
        self._form_content.field_value = field_value
        return self

    def build(self) -> "FormContent":
        return self._form_content
