# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class QueryRuleRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.rule_name: Optional[str] = None
        self.include_deleted: Optional[int] = None
        self.user_id_type: Optional[str] = None

    @staticmethod
    def builder() -> "QueryRuleRequestBuilder":
        return QueryRuleRequestBuilder()


class QueryRuleRequestBuilder(object):

    def __init__(self) -> None:
        query_rule_request = QueryRuleRequest()
        query_rule_request.http_method = HttpMethod.GET
        query_rule_request.uri = "/open-apis/report/v1/rules/query"
        query_rule_request.token_types = {AccessTokenType.TENANT}
        self._query_rule_request: QueryRuleRequest = query_rule_request

    def rule_name(self, rule_name: str) -> "QueryRuleRequestBuilder":
        self._query_rule_request.rule_name = rule_name
        self._query_rule_request.add_query("rule_name", rule_name)
        return self

    def include_deleted(self, include_deleted: int) -> "QueryRuleRequestBuilder":
        self._query_rule_request.include_deleted = include_deleted
        self._query_rule_request.add_query("include_deleted", include_deleted)
        return self

    def user_id_type(self, user_id_type: str) -> "QueryRuleRequestBuilder":
        self._query_rule_request.user_id_type = user_id_type
        self._query_rule_request.add_query("user_id_type", user_id_type)
        return self

    def build(self) -> QueryRuleRequest:
        return self._query_rule_request
