# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .query_task_request_body import QueryTaskRequestBody


class QueryTaskRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[QueryTaskRequestBody] = None

    @staticmethod
    def builder() -> "QueryTaskRequestBuilder":
        return QueryTaskRequestBuilder()


class QueryTaskRequestBuilder(object):

    def __init__(self) -> None:
        query_task_request = QueryTaskRequest()
        query_task_request.http_method = HttpMethod.POST
        query_task_request.uri = "/open-apis/report/v1/tasks/query"
        query_task_request.token_types = {AccessTokenType.TENANT}
        self._query_task_request: QueryTaskRequest = query_task_request

    def user_id_type(self, user_id_type: str) -> "QueryTaskRequestBuilder":
        self._query_task_request.user_id_type = user_id_type
        self._query_task_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: QueryTaskRequestBody) -> "QueryTaskRequestBuilder":
        self._query_task_request.request_body = request_body
        self._query_task_request.body = request_body
        return self

    def build(self) -> QueryTaskRequest:
        return self._query_task_request
