# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .task import Task


class QueryTaskResponseBody(object):
    _types = {
        "items": List[Task],
        "has_more": bool,
        "page_token": str,
    }

    def __init__(self, d=None):
        self.items: Optional[List[Task]] = None
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "QueryTaskResponseBodyBuilder":
        return QueryTaskResponseBodyBuilder()


class QueryTaskResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._query_task_response_body = QueryTaskResponseBody()

    def items(self, items: List[Task]) -> "QueryTaskResponseBodyBuilder":
        self._query_task_response_body.items = items
        return self

    def has_more(self, has_more: bool) -> "QueryTaskResponseBodyBuilder":
        self._query_task_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "QueryTaskResponseBodyBuilder":
        self._query_task_response_body.page_token = page_token
        return self

    def build(self) -> "QueryTaskResponseBody":
        return self._query_task_response_body
