# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .remove_rule_view_request_body import RemoveRuleViewRequestBody


class RemoveRuleViewRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.rule_id: Optional[str] = None
        self.request_body: Optional[RemoveRuleViewRequestBody] = None

    @staticmethod
    def builder() -> "RemoveRuleViewRequestBuilder":
        return RemoveRuleViewRequestBuilder()


class RemoveRuleViewRequestBuilder(object):

    def __init__(self) -> None:
        remove_rule_view_request = RemoveRuleViewRequest()
        remove_rule_view_request.http_method = HttpMethod.POST
        remove_rule_view_request.uri = "/open-apis/report/v1/rules/:rule_id/views/remove"
        remove_rule_view_request.token_types = {AccessTokenType.TENANT}
        self._remove_rule_view_request: RemoveRuleViewRequest = remove_rule_view_request

    def user_id_type(self, user_id_type: str) -> "RemoveRuleViewRequestBuilder":
        self._remove_rule_view_request.user_id_type = user_id_type
        self._remove_rule_view_request.add_query("user_id_type", user_id_type)
        return self

    def rule_id(self, rule_id: str) -> "RemoveRuleViewRequestBuilder":
        self._remove_rule_view_request.rule_id = rule_id
        self._remove_rule_view_request.paths["rule_id"] = str(rule_id)
        return self

    def request_body(self, request_body: RemoveRuleViewRequestBody) -> "RemoveRuleViewRequestBuilder":
        self._remove_rule_view_request.request_body = request_body
        self._remove_rule_view_request.body = request_body
        return self

    def build(self) -> RemoveRuleViewRequest:
        return self._remove_rule_view_request
