# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .form_content import FormContent


class Task(object):
    _types = {
        "task_id": int,
        "rule_name": str,
        "from_user_id": str,
        "from_user_name": str,
        "department_name": str,
        "commit_time": int,
        "form_contents": List[FormContent],
        "rule_id": int,
    }

    def __init__(self, d=None):
        self.task_id: Optional[int] = None
        self.rule_name: Optional[str] = None
        self.from_user_id: Optional[str] = None
        self.from_user_name: Optional[str] = None
        self.department_name: Optional[str] = None
        self.commit_time: Optional[int] = None
        self.form_contents: Optional[List[FormContent]] = None
        self.rule_id: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TaskBuilder":
        return TaskBuilder()


class TaskBuilder(object):
    def __init__(self) -> None:
        self._task = Task()

    def task_id(self, task_id: int) -> "TaskBuilder":
        self._task.task_id = task_id
        return self

    def rule_name(self, rule_name: str) -> "TaskBuilder":
        self._task.rule_name = rule_name
        return self

    def from_user_id(self, from_user_id: str) -> "TaskBuilder":
        self._task.from_user_id = from_user_id
        return self

    def from_user_name(self, from_user_name: str) -> "TaskBuilder":
        self._task.from_user_name = from_user_name
        return self

    def department_name(self, department_name: str) -> "TaskBuilder":
        self._task.department_name = department_name
        return self

    def commit_time(self, commit_time: int) -> "TaskBuilder":
        self._task.commit_time = commit_time
        return self

    def form_contents(self, form_contents: List[FormContent]) -> "TaskBuilder":
        self._task.form_contents = form_contents
        return self

    def rule_id(self, rule_id: int) -> "TaskBuilder":
        self._task.rule_id = rule_id
        return self

    def build(self) -> "Task":
        return self._task
