# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Chunk(object):
    _types = {
        "chunk_id": str,
        "doc_id": str,
        "dataset_id": str,
        "update_time": str,
        "content": str,
        "filter_data": str,
        "score": float,
        "token_num": int,
        "overlength": bool,
    }

    def __init__(self, d=None):
        self.chunk_id: Optional[str] = None
        self.doc_id: Optional[str] = None
        self.dataset_id: Optional[str] = None
        self.update_time: Optional[str] = None
        self.content: Optional[str] = None
        self.filter_data: Optional[str] = None
        self.score: Optional[float] = None
        self.token_num: Optional[int] = None
        self.overlength: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ChunkBuilder":
        return ChunkBuilder()


class ChunkBuilder(object):
    def __init__(self) -> None:
        self._chunk = Chunk()

    def chunk_id(self, chunk_id: str) -> "ChunkBuilder":
        self._chunk.chunk_id = chunk_id
        return self

    def doc_id(self, doc_id: str) -> "ChunkBuilder":
        self._chunk.doc_id = doc_id
        return self

    def dataset_id(self, dataset_id: str) -> "ChunkBuilder":
        self._chunk.dataset_id = dataset_id
        return self

    def update_time(self, update_time: str) -> "ChunkBuilder":
        self._chunk.update_time = update_time
        return self

    def content(self, content: str) -> "ChunkBuilder":
        self._chunk.content = content
        return self

    def filter_data(self, filter_data: str) -> "ChunkBuilder":
        self._chunk.filter_data = filter_data
        return self

    def score(self, score: float) -> "ChunkBuilder":
        self._chunk.score = score
        return self

    def token_num(self, token_num: int) -> "ChunkBuilder":
        self._chunk.token_num = token_num
        return self

    def overlength(self, overlength: bool) -> "ChunkBuilder":
        self._chunk.overlength = overlength
        return self

    def build(self) -> "Chunk":
        return self._chunk
