# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .filter_schema import FilterSchema
from .model_config import ModelConfig


class Dataset(object):
    _types = {
        "dataset_id": str,
        "app_id": str,
        "create_time": str,
        "update_time": str,
        "chunk_num": int,
        "doc_num": int,
        "name": str,
        "description": str,
        "filter_schemas": List[FilterSchema],
        "model_config": ModelConfig,
        "viewer_app_ids": List[str],
    }

    def __init__(self, d=None):
        self.dataset_id: Optional[str] = None
        self.app_id: Optional[str] = None
        self.create_time: Optional[str] = None
        self.update_time: Optional[str] = None
        self.chunk_num: Optional[int] = None
        self.doc_num: Optional[int] = None
        self.name: Optional[str] = None
        self.description: Optional[str] = None
        self.filter_schemas: Optional[List[FilterSchema]] = None
        self.model_config: Optional[ModelConfig] = None
        self.viewer_app_ids: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DatasetBuilder":
        return DatasetBuilder()


class DatasetBuilder(object):
    def __init__(self) -> None:
        self._dataset = Dataset()

    def dataset_id(self, dataset_id: str) -> "DatasetBuilder":
        self._dataset.dataset_id = dataset_id
        return self

    def app_id(self, app_id: str) -> "DatasetBuilder":
        self._dataset.app_id = app_id
        return self

    def create_time(self, create_time: str) -> "DatasetBuilder":
        self._dataset.create_time = create_time
        return self

    def update_time(self, update_time: str) -> "DatasetBuilder":
        self._dataset.update_time = update_time
        return self

    def chunk_num(self, chunk_num: int) -> "DatasetBuilder":
        self._dataset.chunk_num = chunk_num
        return self

    def doc_num(self, doc_num: int) -> "DatasetBuilder":
        self._dataset.doc_num = doc_num
        return self

    def name(self, name: str) -> "DatasetBuilder":
        self._dataset.name = name
        return self

    def description(self, description: str) -> "DatasetBuilder":
        self._dataset.description = description
        return self

    def filter_schemas(self, filter_schemas: List[FilterSchema]) -> "DatasetBuilder":
        self._dataset.filter_schemas = filter_schemas
        return self

    def model_config(self, model_config: ModelConfig) -> "DatasetBuilder":
        self._dataset.model_config = model_config
        return self

    def viewer_app_ids(self, viewer_app_ids: List[str]) -> "DatasetBuilder":
        self._dataset.viewer_app_ids = viewer_app_ids
        return self

    def build(self) -> "Dataset":
        return self._dataset
