# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .scenario_context import ScenarioContext


class DialogSearchRequest(object):
    _types = {
        "tool_raw_instruction": str,
        "scenario_context_schema_version": str,
        "scenario_context": ScenarioContext,
    }

    def __init__(self, d=None):
        self.tool_raw_instruction: Optional[str] = None
        self.scenario_context_schema_version: Optional[str] = None
        self.scenario_context: Optional[ScenarioContext] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DialogSearchRequestBuilder":
        return DialogSearchRequestBuilder()


class DialogSearchRequestBuilder(object):
    def __init__(self) -> None:
        self._dialog_search_request = DialogSearchRequest()

    def tool_raw_instruction(self, tool_raw_instruction: str) -> "DialogSearchRequestBuilder":
        self._dialog_search_request.tool_raw_instruction = tool_raw_instruction
        return self

    def scenario_context_schema_version(self, scenario_context_schema_version: str) -> "DialogSearchRequestBuilder":
        self._dialog_search_request.scenario_context_schema_version = scenario_context_schema_version
        return self

    def scenario_context(self, scenario_context: ScenarioContext) -> "DialogSearchRequestBuilder":
        self._dialog_search_request.scenario_context = scenario_context
        return self

    def build(self) -> "DialogSearchRequest":
        return self._dialog_search_request
