# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .chunk import Chunk


class Doc(object):
    _types = {
        "doc_id": str,
        "filter_data": str,
        "chunks": List[Chunk],
    }

    def __init__(self, d=None):
        self.doc_id: Optional[str] = None
        self.filter_data: Optional[str] = None
        self.chunks: Optional[List[Chunk]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DocBuilder":
        return DocBuilder()


class DocBuilder(object):
    def __init__(self) -> None:
        self._doc = Doc()

    def doc_id(self, doc_id: str) -> "DocBuilder":
        self._doc.doc_id = doc_id
        return self

    def filter_data(self, filter_data: str) -> "DocBuilder":
        self._doc.filter_data = filter_data
        return self

    def chunks(self, chunks: List[Chunk]) -> "DocBuilder":
        self._doc.chunks = chunks
        return self

    def build(self) -> "Doc":
        return self._doc
