# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class DocPassageParam(object):
    _types = {
        "searchable": bool,
        "doc_tokens": List[str],
        "folder_tokens": List[str],
        "obj_ids": List[str],
    }

    def __init__(self, d=None):
        self.searchable: Optional[bool] = None
        self.doc_tokens: Optional[List[str]] = None
        self.folder_tokens: Optional[List[str]] = None
        self.obj_ids: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DocPassageParamBuilder":
        return DocPassageParamBuilder()


class DocPassageParamBuilder(object):
    def __init__(self) -> None:
        self._doc_passage_param = DocPassageParam()

    def searchable(self, searchable: bool) -> "DocPassageParamBuilder":
        self._doc_passage_param.searchable = searchable
        return self

    def doc_tokens(self, doc_tokens: List[str]) -> "DocPassageParamBuilder":
        self._doc_passage_param.doc_tokens = doc_tokens
        return self

    def folder_tokens(self, folder_tokens: List[str]) -> "DocPassageParamBuilder":
        self._doc_passage_param.folder_tokens = folder_tokens
        return self

    def obj_ids(self, obj_ids: List[str]) -> "DocPassageParamBuilder":
        self._doc_passage_param.obj_ids = obj_ids
        return self

    def build(self) -> "DocPassageParam":
        return self._doc_passage_param
