# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetSchemaRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.schema_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetSchemaRequestBuilder":
        return GetSchemaRequestBuilder()


class GetSchemaRequestBuilder(object):

    def __init__(self) -> None:
        get_schema_request = GetSchemaRequest()
        get_schema_request.http_method = HttpMethod.GET
        get_schema_request.uri = "/open-apis/search/v2/schemas/:schema_id"
        get_schema_request.token_types = {AccessTokenType.TENANT}
        self._get_schema_request: GetSchemaRequest = get_schema_request

    def schema_id(self, schema_id: str) -> "GetSchemaRequestBuilder":
        self._get_schema_request.schema_id = schema_id
        self._get_schema_request.paths["schema_id"] = str(schema_id)
        return self

    def build(self) -> GetSchemaRequest:
        return self._get_schema_request
