# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class HelpdeskPassageParam(object):
    _types = {
        "searchable": bool,
        "helpdesk_ids": List[str],
    }

    def __init__(self, d=None):
        self.searchable: Optional[bool] = None
        self.helpdesk_ids: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "HelpdeskPassageParamBuilder":
        return HelpdeskPassageParamBuilder()


class HelpdeskPassageParamBuilder(object):
    def __init__(self) -> None:
        self._helpdesk_passage_param = HelpdeskPassageParam()

    def searchable(self, searchable: bool) -> "HelpdeskPassageParamBuilder":
        self._helpdesk_passage_param.searchable = searchable
        return self

    def helpdesk_ids(self, helpdesk_ids: List[str]) -> "HelpdeskPassageParamBuilder":
        self._helpdesk_passage_param.helpdesk_ids = helpdesk_ids
        return self

    def build(self) -> "HelpdeskPassageParam":
        return self._helpdesk_passage_param
