# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .acl import Acl
from .item_content import ItemContent
from .item_metadata import ItemMetadata


class Item(object):
    _types = {
        "id": str,
        "acl": List[Acl],
        "metadata": ItemMetadata,
        "structured_data": str,
        "content": ItemContent,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.acl: Optional[List[Acl]] = None
        self.metadata: Optional[ItemMetadata] = None
        self.structured_data: Optional[str] = None
        self.content: Optional[ItemContent] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ItemBuilder":
        return ItemBuilder()


class ItemBuilder(object):
    def __init__(self) -> None:
        self._item = Item()

    def id(self, id: str) -> "ItemBuilder":
        self._item.id = id
        return self

    def acl(self, acl: List[Acl]) -> "ItemBuilder":
        self._item.acl = acl
        return self

    def metadata(self, metadata: ItemMetadata) -> "ItemBuilder":
        self._item.metadata = metadata
        return self

    def structured_data(self, structured_data: str) -> "ItemBuilder":
        self._item.structured_data = structured_data
        return self

    def content(self, content: ItemContent) -> "ItemBuilder":
        self._item.content = content
        return self

    def build(self) -> "Item":
        return self._item
