# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ItemMetadata(object):
    _types = {
        "title": str,
        "source_url": str,
        "create_time": int,
        "update_time": int,
        "source_url_mobile": str,
    }

    def __init__(self, d=None):
        self.title: Optional[str] = None
        self.source_url: Optional[str] = None
        self.create_time: Optional[int] = None
        self.update_time: Optional[int] = None
        self.source_url_mobile: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ItemMetadataBuilder":
        return ItemMetadataBuilder()


class ItemMetadataBuilder(object):
    def __init__(self) -> None:
        self._item_metadata = ItemMetadata()

    def title(self, title: str) -> "ItemMetadataBuilder":
        self._item_metadata.title = title
        return self

    def source_url(self, source_url: str) -> "ItemMetadataBuilder":
        self._item_metadata.source_url = source_url
        return self

    def create_time(self, create_time: int) -> "ItemMetadataBuilder":
        self._item_metadata.create_time = create_time
        return self

    def update_time(self, update_time: int) -> "ItemMetadataBuilder":
        self._item_metadata.update_time = update_time
        return self

    def source_url_mobile(self, source_url_mobile: str) -> "ItemMetadataBuilder":
        self._item_metadata.source_url_mobile = source_url_mobile
        return self

    def build(self) -> "ItemMetadata":
        return self._item_metadata
