# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ItemRecord(object):
    _types = {
        "item_id": str,
        "data_source_id": str,
        "version": str,
        "created_at": str,
        "updated_at": str,
    }

    def __init__(self, d=None):
        self.item_id: Optional[str] = None
        self.data_source_id: Optional[str] = None
        self.version: Optional[str] = None
        self.created_at: Optional[str] = None
        self.updated_at: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ItemRecordBuilder":
        return ItemRecordBuilder()


class ItemRecordBuilder(object):
    def __init__(self) -> None:
        self._item_record = ItemRecord()

    def item_id(self, item_id: str) -> "ItemRecordBuilder":
        self._item_record.item_id = item_id
        return self

    def data_source_id(self, data_source_id: str) -> "ItemRecordBuilder":
        self._item_record.data_source_id = data_source_id
        return self

    def version(self, version: str) -> "ItemRecordBuilder":
        self._item_record.version = version
        return self

    def created_at(self, created_at: str) -> "ItemRecordBuilder":
        self._item_record.created_at = created_at
        return self

    def updated_at(self, updated_at: str) -> "ItemRecordBuilder":
        self._item_record.updated_at = updated_at
        return self

    def build(self) -> "ItemRecord":
        return self._item_record
