# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class LlmModelConfig(object):
    _types = {
        "model_name": str,
        "prompt": str,
        "max_token": int,
        "temperature": float,
    }

    def __init__(self, d=None):
        self.model_name: Optional[str] = None
        self.prompt: Optional[str] = None
        self.max_token: Optional[int] = None
        self.temperature: Optional[float] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "LlmModelConfigBuilder":
        return LlmModelConfigBuilder()


class LlmModelConfigBuilder(object):
    def __init__(self) -> None:
        self._llm_model_config = LlmModelConfig()

    def model_name(self, model_name: str) -> "LlmModelConfigBuilder":
        self._llm_model_config.model_name = model_name
        return self

    def prompt(self, prompt: str) -> "LlmModelConfigBuilder":
        self._llm_model_config.prompt = prompt
        return self

    def max_token(self, max_token: int) -> "LlmModelConfigBuilder":
        self._llm_model_config.max_token = max_token
        return self

    def temperature(self, temperature: float) -> "LlmModelConfigBuilder":
        self._llm_model_config.temperature = temperature
        return self

    def build(self) -> "LlmModelConfig":
        return self._llm_model_config
