# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class MemoryMessage(object):
    _types = {
        "role": str,
        "content": str,
    }

    def __init__(self, d=None):
        self.role: Optional[str] = None
        self.content: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MemoryMessageBuilder":
        return MemoryMessageBuilder()


class MemoryMessageBuilder(object):
    def __init__(self) -> None:
        self._memory_message = MemoryMessage()

    def role(self, role: str) -> "MemoryMessageBuilder":
        self._memory_message.role = role
        return self

    def content(self, content: str) -> "MemoryMessageBuilder":
        self._memory_message.content = content
        return self

    def build(self) -> "MemoryMessage":
        return self._memory_message
