# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Passage(object):
    _types = {
        "passage_id": str,
        "passage_source": int,
        "content": str,
        "title": str,
        "url": str,
        "score": float,
        "extra": str,
    }

    def __init__(self, d=None):
        self.passage_id: Optional[str] = None
        self.passage_source: Optional[int] = None
        self.content: Optional[str] = None
        self.title: Optional[str] = None
        self.url: Optional[str] = None
        self.score: Optional[float] = None
        self.extra: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PassageBuilder":
        return PassageBuilder()


class PassageBuilder(object):
    def __init__(self) -> None:
        self._passage = Passage()

    def passage_id(self, passage_id: str) -> "PassageBuilder":
        self._passage.passage_id = passage_id
        return self

    def passage_source(self, passage_source: int) -> "PassageBuilder":
        self._passage.passage_source = passage_source
        return self

    def content(self, content: str) -> "PassageBuilder":
        self._passage.content = content
        return self

    def title(self, title: str) -> "PassageBuilder":
        self._passage.title = title
        return self

    def url(self, url: str) -> "PassageBuilder":
        self._passage.url = url
        return self

    def score(self, score: float) -> "PassageBuilder":
        self._passage.score = score
        return self

    def extra(self, extra: str) -> "PassageBuilder":
        self._passage.extra = extra
        return self

    def build(self) -> "Passage":
        return self._passage
