# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .memory_message import MemoryMessage
from .scenario_context_extra import ScenarioContextExtra
from .system_info import SystemInfo


class ScenarioContext(object):
    _types = {
        "extra": ScenarioContextExtra,
        "system_info": SystemInfo,
        "memory": List[MemoryMessage],
        "scenario": str,
        "work_mode": int,
        "tool_raw_instruction": str,
    }

    def __init__(self, d=None):
        self.extra: Optional[ScenarioContextExtra] = None
        self.system_info: Optional[SystemInfo] = None
        self.memory: Optional[List[MemoryMessage]] = None
        self.scenario: Optional[str] = None
        self.work_mode: Optional[int] = None
        self.tool_raw_instruction: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ScenarioContextBuilder":
        return ScenarioContextBuilder()


class ScenarioContextBuilder(object):
    def __init__(self) -> None:
        self._scenario_context = ScenarioContext()

    def extra(self, extra: ScenarioContextExtra) -> "ScenarioContextBuilder":
        self._scenario_context.extra = extra
        return self

    def system_info(self, system_info: SystemInfo) -> "ScenarioContextBuilder":
        self._scenario_context.system_info = system_info
        return self

    def memory(self, memory: List[MemoryMessage]) -> "ScenarioContextBuilder":
        self._scenario_context.memory = memory
        return self

    def scenario(self, scenario: str) -> "ScenarioContextBuilder":
        self._scenario_context.scenario = scenario
        return self

    def work_mode(self, work_mode: int) -> "ScenarioContextBuilder":
        self._scenario_context.work_mode = work_mode
        return self

    def tool_raw_instruction(self, tool_raw_instruction: str) -> "ScenarioContextBuilder":
        self._scenario_context.tool_raw_instruction = tool_raw_instruction
        return self

    def build(self) -> "ScenarioContext":
        return self._scenario_context
