# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .schema_display_field_mapping import SchemaDisplayFieldMapping


class SchemaDisplay(object):
    _types = {
        "card_key": str,
        "fields_mapping": List[SchemaDisplayFieldMapping],
    }

    def __init__(self, d=None):
        self.card_key: Optional[str] = None
        self.fields_mapping: Optional[List[SchemaDisplayFieldMapping]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SchemaDisplayBuilder":
        return SchemaDisplayBuilder()


class SchemaDisplayBuilder(object):
    def __init__(self) -> None:
        self._schema_display = SchemaDisplay()

    def card_key(self, card_key: str) -> "SchemaDisplayBuilder":
        self._schema_display.card_key = card_key
        return self

    def fields_mapping(self, fields_mapping: List[SchemaDisplayFieldMapping]) -> "SchemaDisplayBuilder":
        self._schema_display.fields_mapping = fields_mapping
        return self

    def build(self) -> "SchemaDisplay":
        return self._schema_display
