# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n_meta import I18nMeta
from .schema_predefine_enum_struct import SchemaPredefineEnumStruct


class SchemaFilterOptions(object):
    _types = {
        "display_name": str,
        "i18n_display_name": I18nMeta,
        "option_mode": str,
        "associated_smart_filter": str,
        "filter_type": str,
        "predefine_enum_values": List[SchemaPredefineEnumStruct],
        "enable_client_filter": bool,
        "reference_datasource_id": str,
    }

    def __init__(self, d=None):
        self.display_name: Optional[str] = None
        self.i18n_display_name: Optional[I18nMeta] = None
        self.option_mode: Optional[str] = None
        self.associated_smart_filter: Optional[str] = None
        self.filter_type: Optional[str] = None
        self.predefine_enum_values: Optional[List[SchemaPredefineEnumStruct]] = None
        self.enable_client_filter: Optional[bool] = None
        self.reference_datasource_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SchemaFilterOptionsBuilder":
        return SchemaFilterOptionsBuilder()


class SchemaFilterOptionsBuilder(object):
    def __init__(self) -> None:
        self._schema_filter_options = SchemaFilterOptions()

    def display_name(self, display_name: str) -> "SchemaFilterOptionsBuilder":
        self._schema_filter_options.display_name = display_name
        return self

    def i18n_display_name(self, i18n_display_name: I18nMeta) -> "SchemaFilterOptionsBuilder":
        self._schema_filter_options.i18n_display_name = i18n_display_name
        return self

    def option_mode(self, option_mode: str) -> "SchemaFilterOptionsBuilder":
        self._schema_filter_options.option_mode = option_mode
        return self

    def associated_smart_filter(self, associated_smart_filter: str) -> "SchemaFilterOptionsBuilder":
        self._schema_filter_options.associated_smart_filter = associated_smart_filter
        return self

    def filter_type(self, filter_type: str) -> "SchemaFilterOptionsBuilder":
        self._schema_filter_options.filter_type = filter_type
        return self

    def predefine_enum_values(self,
                              predefine_enum_values: List[SchemaPredefineEnumStruct]) -> "SchemaFilterOptionsBuilder":
        self._schema_filter_options.predefine_enum_values = predefine_enum_values
        return self

    def enable_client_filter(self, enable_client_filter: bool) -> "SchemaFilterOptionsBuilder":
        self._schema_filter_options.enable_client_filter = enable_client_filter
        return self

    def reference_datasource_id(self, reference_datasource_id: str) -> "SchemaFilterOptionsBuilder":
        self._schema_filter_options.reference_datasource_id = reference_datasource_id
        return self

    def build(self) -> "SchemaFilterOptions":
        return self._schema_filter_options
