# Code generated by Lark OpenAPI.

from typing import *

from lark_oapi.core.construct import init
from .schema_display_option import SchemaDisplayOption


class SchemaPropertyDefinition(object):
    _types = {
        "name": str,
        "is_returnable": bool,
        "is_repeatable": bool,
        "is_sortable": bool,
        "is_facetable": bool,
        "is_wildcard_searchable": bool,
        "type": str,
        "display_options": SchemaDisplayOption,
    }

    def __init__(self, d=None):
        self.name: Optional[str] = None
        self.is_returnable: Optional[bool] = None
        self.is_repeatable: Optional[bool] = None
        self.is_sortable: Optional[bool] = None
        self.is_facetable: Optional[bool] = None
        self.is_wildcard_searchable: Optional[bool] = None
        self.type: Optional[str] = None
        self.display_options: Optional[SchemaDisplayOption] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SchemaPropertyDefinitionBuilder":
        return SchemaPropertyDefinitionBuilder()


class SchemaPropertyDefinitionBuilder(object):
    def __init__(self) -> None:
        self._schema_property_definition = SchemaPropertyDefinition()

    def name(self, name: str) -> "SchemaPropertyDefinitionBuilder":
        self._schema_property_definition.name = name
        return self

    def is_returnable(self, is_returnable: bool) -> "SchemaPropertyDefinitionBuilder":
        self._schema_property_definition.is_returnable = is_returnable
        return self

    def is_repeatable(self, is_repeatable: bool) -> "SchemaPropertyDefinitionBuilder":
        self._schema_property_definition.is_repeatable = is_repeatable
        return self

    def is_sortable(self, is_sortable: bool) -> "SchemaPropertyDefinitionBuilder":
        self._schema_property_definition.is_sortable = is_sortable
        return self

    def is_facetable(self, is_facetable: bool) -> "SchemaPropertyDefinitionBuilder":
        self._schema_property_definition.is_facetable = is_facetable
        return self

    def is_wildcard_searchable(self, is_wildcard_searchable: bool) -> "SchemaPropertyDefinitionBuilder":
        self._schema_property_definition.is_wildcard_searchable = is_wildcard_searchable
        return self

    def type(self, type: str) -> "SchemaPropertyDefinitionBuilder":
        self._schema_property_definition.type = type
        return self

    def display_options(self, display_options: SchemaDisplayOption) -> "SchemaPropertyDefinitionBuilder":
        self._schema_property_definition.display_options = display_options
        return self

    def build(self) -> "SchemaPropertyDefinition":
        return self._schema_property_definition
