# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class SystemInfo(object):
    _types = {
        "time": str,
        "time_zone": str,
        "lang": str,
        "brand": str,
        "weekday": str,
        "session_id": str,
        "shadow_name": str,
        "msg_id": str,
        "agent_id": str,
    }

    def __init__(self, d=None):
        self.time: Optional[str] = None
        self.time_zone: Optional[str] = None
        self.lang: Optional[str] = None
        self.brand: Optional[str] = None
        self.weekday: Optional[str] = None
        self.session_id: Optional[str] = None
        self.shadow_name: Optional[str] = None
        self.msg_id: Optional[str] = None
        self.agent_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SystemInfoBuilder":
        return SystemInfoBuilder()


class SystemInfoBuilder(object):
    def __init__(self) -> None:
        self._system_info = SystemInfo()

    def time(self, time: str) -> "SystemInfoBuilder":
        self._system_info.time = time
        return self

    def time_zone(self, time_zone: str) -> "SystemInfoBuilder":
        self._system_info.time_zone = time_zone
        return self

    def lang(self, lang: str) -> "SystemInfoBuilder":
        self._system_info.lang = lang
        return self

    def brand(self, brand: str) -> "SystemInfoBuilder":
        self._system_info.brand = brand
        return self

    def weekday(self, weekday: str) -> "SystemInfoBuilder":
        self._system_info.weekday = weekday
        return self

    def session_id(self, session_id: str) -> "SystemInfoBuilder":
        self._system_info.session_id = session_id
        return self

    def shadow_name(self, shadow_name: str) -> "SystemInfoBuilder":
        self._system_info.shadow_name = shadow_name
        return self

    def msg_id(self, msg_id: str) -> "SystemInfoBuilder":
        self._system_info.msg_id = msg_id
        return self

    def agent_id(self, agent_id: str) -> "SystemInfoBuilder":
        self._system_info.agent_id = agent_id
        return self

    def build(self) -> "SystemInfo":
        return self._system_info
