# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class WikiPassageParam(object):
    _types = {
        "searchable": bool,
        "space_ids": List[str],
        "obj_ids": List[str],
        "wiki_tokens": List[str],
        "node_tokens": List[str],
    }

    def __init__(self, d=None):
        self.searchable: Optional[bool] = None
        self.space_ids: Optional[List[str]] = None
        self.obj_ids: Optional[List[str]] = None
        self.wiki_tokens: Optional[List[str]] = None
        self.node_tokens: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "WikiPassageParamBuilder":
        return WikiPassageParamBuilder()


class WikiPassageParamBuilder(object):
    def __init__(self) -> None:
        self._wiki_passage_param = WikiPassageParam()

    def searchable(self, searchable: bool) -> "WikiPassageParamBuilder":
        self._wiki_passage_param.searchable = searchable
        return self

    def space_ids(self, space_ids: List[str]) -> "WikiPassageParamBuilder":
        self._wiki_passage_param.space_ids = space_ids
        return self

    def obj_ids(self, obj_ids: List[str]) -> "WikiPassageParamBuilder":
        self._wiki_passage_param.obj_ids = obj_ids
        return self

    def wiki_tokens(self, wiki_tokens: List[str]) -> "WikiPassageParamBuilder":
        self._wiki_passage_param.wiki_tokens = wiki_tokens
        return self

    def node_tokens(self, node_tokens: List[str]) -> "WikiPassageParamBuilder":
        self._wiki_passage_param.node_tokens = node_tokens
        return self

    def build(self) -> "WikiPassageParam":
        return self._wiki_passage_param
